// $Id: CEndian.cpp,v 1.4 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CEndian.hpp"
using Exponent::Host::CEndian;

//	===========================================================================
CEndian::EEndian CEndian::getSystemEndianessRunTime()
{	
	short int word = 0x0001;
	char *byte     = (char *)&word;
	return (byte[0] ? e_littleEndian : e_bigEndian);
}

//	===========================================================================
CEndian::EEndian CEndian::getSystemEndianessCompileTime()
{
#ifdef WIN32
	return e_littleEndian;
#else
	return e_bigEndian;
#endif
}

//	===========================================================================
int CEndian::convertThreeBytesToTwentyFourBitInt(const char *bytes)
{
#ifdef WIN32
	return (((int)bytes[2]) << 16) | (((unsigned int)(unsigned char)bytes[1]) << 8) | ((unsigned int)(unsigned char)bytes[0]);
#else
	return (((int)bytes[0]) << 16) | (((unsigned int)(unsigned char)bytes[1]) << 8) | ((unsigned int)(unsigned char)bytes[2]);
#endif
}

//	===========================================================================
void CEndian::convertTwentyFourBitIntToThreeBytes(const int value, char *bytes)
{
	bytes[0] = (char)( value		& 0xff); 
	bytes[1] = (char)((value >> 8)  & 0xff); 
	bytes[2] = (char)((value >> 16) & 0xff);
}

//	===========================================================================
unsigned short CEndian::swapDataBytesIfSystemIsBigEndian(unsigned short bytes)
{
#ifdef WIN32
	return bytes;
#else
	return (unsigned short)((bytes << 8) | (bytes >> 8));
#endif
}

//	===========================================================================
unsigned int CEndian::swapDataBytesIfSystemIsBigEndian(unsigned int bytes)
{
#ifdef WIN32
	return bytes;
#else
	return (bytes << 24) + ((bytes & 0xff00) << 8) + ((bytes >> 8) & 0xff00) + (bytes >> 24);
#endif
}

//	===========================================================================
void CEndian::swap2Bytes(unsigned char *buffer)
{
	unsigned char myTemp = buffer[0];
	buffer[0] = buffer[1];
	buffer[1] = myTemp;
}

//	===========================================================================
void CEndian::swapFourBytesIfSystemIsLittleEndian(unsigned char *buffer)
{
#ifdef WIN32
	register unsigned char val;

	// Swap 1st and 4th bytes 
	val           = *(buffer);
	*(buffer)     = *(buffer + 3);
	*(buffer + 3) = val;

	// Swap 2nd and 3rd bytes 
	buffer		 += 1;
	val           = *(buffer);
	*(buffer)     = *(buffer + 1);
	*(buffer + 1) = val;
#else
	#ifdef __i386
		register unsigned char val;

		// Swap 1st and 4th bytes 
		val           = *(buffer);
		*(buffer)     = *(buffer + 3);
		*(buffer + 3) = val;

		// Swap 2nd and 3rd bytes 
		buffer		 += 1;
		val           = *(buffer);
		*(buffer)     = *(buffer + 1);
		*(buffer + 1) = val;
	#else
		// Dont need to do the swap operation
	#endif
#endif
}